#ifndef MESSAGES_H
#define MESSAGES_H

////////////////////////////////////////
// Dialog
////////////////////////////////////////
//
//  Values are 32 bit values layed out as follows:
//
//   3 3 2 2 2 2 2 2 2 2 2 2 1 1 1 1 1 1 1 1 1 1
//   1 0 9 8 7 6 5 4 3 2 1 0 9 8 7 6 5 4 3 2 1 0 9 8 7 6 5 4 3 2 1 0
//  +---+-+-+-----------------------+-------------------------------+
//  |Sev|C|R|     Facility          |               Code            |
//  +---+-+-+-----------------------+-------------------------------+
//
//  where
//
//      Sev - is the severity code
//
//          00 - Success
//          01 - Informational
//          10 - Warning
//          11 - Error
//
//      C - is the Customer code flag
//
//      R - is a reserved bit
//
//      Facility - is the facility code
//
//      Code - is the facility's status code
//
//
// Define the facility codes
//


//
// Define the severity codes
//


//
// MessageId: IDS_SPEED
//
// MessageText:
//
//  Speed%0
//
#define IDS_SPEED                        0x00008235L

//
// MessageId: IDS_INITIAL
//
// MessageText:
//
//  Initial cracks%0
//
#define IDS_INITIAL                      0x00008236L

//
// MessageId: IDS_MAXSTEPS
//
// MessageText:
//
//  Maximum number of steps%0
//
#define IDS_MAXSTEPS                     0x00008237L

//
// MessageId: IDS_MAX
//
// MessageText:
//
//  Max cracks%0
//
#define IDS_MAX                          0x00008238L

//
// MessageId: IDS_GRAIN
//
// MessageText:
//
//  Grain%0
//
#define IDS_GRAIN                        0x00008239L

//
// MessageId: IDS_CIRCLES
//
// MessageText:
//
//  Circles%0
//
#define IDS_CIRCLES                      0x0000823AL

//
// MessageId: IDS_CIRCLEDEC
//
// MessageText:
//
//  Decrease number of circles over time%0
//
#define IDS_CIRCLEDEC                    0x0000823BL

//
// MessageId: IDS_FORE
//
// MessageText:
//
//  Foreground %0
//
#define IDS_FORE                         0x0000823CL

//
// MessageId: IDS_BACK
//
// MessageText:
//
//  Background %0
//
#define IDS_BACK                         0x0000823DL

//
// MessageId: IDS_THEME
//
// MessageText:
//
//  Theme %0
//
#define IDS_THEME                        0x0000823EL

//
// MessageId: IDS_WIREFRAME
//
// MessageText:
//
//  Wireframe only%0
//
#define IDS_WIREFRAME                    0x0000823FL

//
// MessageId: IDS_RANDOM
//
// MessageText:
//
//  Use random settings%0
//
#define IDS_RANDOM                       0x00008240L

//
// MessageId: IDS_THEME_STD
//
// MessageText:
//
//  Standard theme %0
//
#define IDS_THEME_STD                    0x00008241L

//
// MessageId: IDS_THEME_RANDOM
//
// MessageText:
//
//  Random color%0
//
#define IDS_THEME_RANDOM                 0x00008242L

//
// MessageId: IDS_THEME_RED
//
// MessageText:
//
//  Red%0
//
#define IDS_THEME_RED                    0x00008243L

//
// MessageId: IDS_THEME_BLUE
//
// MessageText:
//
//  Blue%0
//
#define IDS_THEME_BLUE                   0x00008244L

//
// MessageId: IDS_THEME_GREEN
//
// MessageText:
//
//  Green%0
//
#define IDS_THEME_GREEN                  0x00008245L

//
// MessageId: IDS_THEME_GRAY
//
// MessageText:
//
//  Gray%0
//
#define IDS_THEME_GRAY                   0x00008246L

//
// MessageId: IDS_THEME_YELLOW
//
// MessageText:
//
//  Yellow%0
//
#define IDS_THEME_YELLOW                 0x00008247L

//
// MessageId: IDS_THEME_CHAOS
//
// MessageText:
//
//  Chaos%0
//
#define IDS_THEME_CHAOS                  0x00008248L

//
// MessageId: IDS_THEME_LIGHT
//
// MessageText:
//
//  Light%0
//
#define IDS_THEME_LIGHT                  0x00008249L

//
// MessageId: IDS_THEME_DARK
//
// MessageText:
//
//  Dark%0
//
#define IDS_THEME_DARK                   0x0000824AL


#endif
