/*
 * Rendering utility functions
 * $Id: Render.cpp 383 2007-05-07 13:25:27Z fred $
 *
 * Copyright (c) 2006 Fred-Markus Stober <mail@fredstober.de>
 *
 * Permission is hereby granted, free of charge, to any person
 * obtaining a copy of this software and associated documentation
 * files (the "Software"), to deal in the Software without
 * restriction, including without limitation the rights to use,
 * copy, modify, merge, publish, distribute, sublicense, and/or sell
 * copies of the Software, and to permit persons to whom the
 * Software is furnished to do so, subject to the following
 * conditions:

 * The above copyright notice and this permission notice shall be
 * included in all copies or substantial portions of the Software.

 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND,
 * EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES
 * OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND
 * NONINFRINGEMENT. IN NO EVENT SHALL THE AUTHORS OR COPYRIGHT
 * HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY,
 * WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING
 * FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR
 * OTHER DEALINGS IN THE SOFTWARE.
 *
 */

#include "Render.h"
#include "DDrawUtils.h"

void InitRenderer(HWND hWnd)
{
#ifdef DIRECT3D
	D3DInit(hWnd);
#else
	DDInit(hWnd);
#endif
}

void ExitRenderer()
{
#ifdef DIRECT3D
	D3DExit();
#else
	DDExit();
#endif
}

void ScreenShot(HWND hWnd)
{
#ifdef DIRECT3D
	D3DScreenShot(hWnd);
#else
	DDScreenShot(hWnd);
#endif
}

void BeginPixelDraw()
{
#ifdef DIRECT3D
	D3DBeginPixelDraw();
#else
	DDBeginPixelDraw();
#endif
}

void EndPixelDraw()
{
#ifdef DIRECT3D
	D3DEndPixelDraw();
#else
	DDEndPixelDraw();
#endif
}

void DrawBackground(const DWORD Color)
{
#ifdef DIRECT3D
	D3DDrawBackground(Color);
#else
	DDDrawBackground(Color);
#endif
}

void DrawText(const char *text)
{
#ifdef DIRECT3D
	D3DDrawText(text);
#else
	DDDrawText(text);
#endif
}
