/*
 * Rendering utility functions
 * $Id: Render.h 383 2007-05-07 13:25:27Z fred $
 *
 * Copyright (c) 2006 Fred-Markus Stober <mail@fredstober.de>
 *
 * Permission is hereby granted, free of charge, to any person
 * obtaining a copy of this software and associated documentation
 * files (the "Software"), to deal in the Software without
 * restriction, including without limitation the rights to use,
 * copy, modify, merge, publish, distribute, sublicense, and/or sell
 * copies of the Software, and to permit persons to whom the
 * Software is furnished to do so, subject to the following
 * conditions:

 * The above copyright notice and this permission notice shall be
 * included in all copies or substantial portions of the Software.

 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND,
 * EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES
 * OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND
 * NONINFRINGEMENT. IN NO EVENT SHALL THE AUTHORS OR COPYRIGHT
 * HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY,
 * WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING
 * FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR
 * OTHER DEALINGS IN THE SOFTWARE.
 *
 */

#ifndef RENDER_H
#define RENDER_H

#define WIN32_LEAN_AND_MEAN
#include <windows.h>

void InitRenderer(HWND hWnd);
void ExitRenderer();
void ScreenShot(HWND hWnd);

typedef void (*DrawPixelColorProc)(const WORD x, const WORD y, const DWORD Color);
typedef void (*DrawPixelColorAlphaProc)(const WORD x, const WORD y, const DWORD Color, const double alpha);
typedef void (*DrawFadeOutProc)(const DWORD Color, bool slow);

void BeginPixelDraw();
void EndPixelDraw();

extern DrawPixelColorProc DrawPixelColor;
extern DrawPixelColorAlphaProc DrawPixelColorAlpha;
extern DrawFadeOutProc DrawFadeOut;

void DrawBackground(const DWORD Color);
void DrawText(const char *text);

#endif
